DROP TABLE IF EXISTS `products_options_values`;
CREATE TABLE `products_options_values` (
	`products_options_values_id`   int(11)       NOT NULL DEFAULT '0',
	`language_id`                  int(11)       NOT NULL DEFAULT '1',
	`option_value_id`              INT           NULL     DEFAULT NULL COMMENT 'mirrors `properties_values`.`properties_values_id`',
	`products_options_values_name` varchar(255)  NOT NULL DEFAULT '',
	`description`                  varchar(255)  NOT NULL DEFAULT '' COMMENT 'mirrors `properties_values_description`.`description`',
	`gm_filename`                  varchar(255)  NOT NULL DEFAULT '',
	`sort_order`                   int(10)       NOT NULL DEFAULT '0' COMMENT 'mirrors `properties_values`.`sort_order`',
	`value_model`                  varchar(64)   NOT NULL DEFAULT '' COMMENT 'mirrors `properties_values`.`value_model`',
	`weight`                       decimal(9, 4) NOT NULL DEFAULT '0.0000' COMMENT 'mirrors `properties_values`.`weight`',
	`value_price`                  decimal(9, 4) NOT NULL DEFAULT '0.0000' COMMENT 'mirrors `properties_values`.`value_price`',
	`display_image`                VARCHAR(256)  NULL COMMENT 'mirrors `properties_values`.`display_image`',
	`stock_type`                   VARCHAR(32)   NOT NULL DEFAULT 'not-managed' COMMENT 'mirrors `properties_values`.`stock_type`',
	`stock`                        decimal(9, 4) NOT NULL DEFAULT 0.0000 COMMENT 'mirrors `properties_values`.`stock`',
	`stock_centrally_managed`      int(1)        NOT NULL DEFAULT 0 COMMENT 'mirrors `properties_values`.`stock_centrally_managed`',
	PRIMARY KEY (`products_options_values_id`, `language_id`),
	KEY `products_options_values_name`(`products_options_values_name`, `language_id`)
)
	ENGINE = InnoDB
	DEFAULT CHARSET = `utf8`;


INSERT INTO `products_options_values`
VALUES (1, 1, 1, 'S', '', '', 1, 's', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(1, 2, 1, 'S', '', '', 1, 's', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(2, 1, 2, 'M', '', '', 2, 'm', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(2, 2, 2, 'M', '', '', 2, 'm', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(3, 1, 3, 'L', '', '', 3, 'l', '0.0000', '5.0000', '', 'not-managed', '0.0000', 0),
	(3, 2, 3, 'L', '', '', 3, 'l', '0.0000', '5.0000', '', 'not-managed', '0.0000', 0),
	(4, 1, 4, 'Gold', '', '', 4, 'gold', '0.0000', '0.0000', 'yellow.png', 'not-managed', '0.0000', 0),
	(4, 2, 4, 'Gold', '', '', 4, 'gold', '0.0000', '0.0000', 'yellow.png', 'not-managed', '0.0000', 0),
	(5, 1, 5, 'Red', '', '', 5, 'red', '0.0000', '0.0000', 'red.png', 'not-managed', '0.0000', 0),
	(5, 2, 5, 'Rot', '', '', 5, 'rot', '0.0000', '0.0000', 'red.png', 'not-managed', '0.0000', 0),
	(6, 1, 6, 'Black', '', '', 6, 'black', '0.0000', '2.0000', 'black.png', 'not-managed', '0.0000', 0),
	(6, 2, 6, 'Schwarz', '', '', 6, 'schwarz', '0.0000', '2.0000', 'black.png', 'not-managed', '0.0000', 0),
	(7, 1, 7, 'Yes', '', '', 7, 'ja', '0.0000', '5.0000', '', 'not-managed', '0.0000', 0),
	(7, 2, 7, 'Ja', '', '', 7, 'ja', '0.0000', '5.0000', '', 'not-managed', '0.0000', 0),
	(8, 1, 8, 'No', '', '', 8, 'nein', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(8, 2, 8, 'Nein', '', '', 8, 'nein', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(9, 1, 9, 'HTML', '', '', 1, 'html', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(9, 2, 9, 'HTML', '', '', 1, 'html', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(10, 1, 10, 'PDF', '', '', 2, 'pdf', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(10, 2, 10, 'PDF', '', '', 2, 'pdf', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(11, 1, 11, '36', '', '', 1, '36', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(11, 2, 11, '36', '', '', 1, '36', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(12, 1, 12, '37', '', '', 2, '37', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(12, 2, 12, '37', '', '', 2, '37', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(13, 1, 13, '38', '', '', 3, '38', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(13, 2, 13, '38', '', '', 3, '38', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(14, 1, 14, '39', '', '', 4, '39', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(14, 2, 14, '39', '', '', 4, '39', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(15, 1, 15, '40', '', '', 5, '40', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(15, 2, 15, '40', '', '', 5, '40', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(16, 1, 16, '41', '', '', 6, '41', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(16, 2, 16, '41', '', '', 6, '41', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(17, 1, 17, '42', '', '', 7, '42', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(17, 2, 17, '42', '', '', 7, '42', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(18, 1, 18, '43', '', '', 8, '43', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(18, 2, 18, '43', '', '', 8, '43', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(19, 1, 19, '44', '', '', 9, '44', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(19, 2, 19, '44', '', '', 9, '44', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(20, 1, 20, '45', '', '', 10, '45', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(20, 2, 20, '45', '', '', 10, '45', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(21, 1, 21, '46', '', '', 11, '46', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(21, 2, 21, '46', '', '', 11, '46', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(22, 1, 22, '5 years', '', '', 1, '5', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(22, 2, 22, '5 Jahre', '', '', 1, '5', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(23, 1, 23, '2 years', '', '', 2, '2', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(23, 2, 23, '2 Jahre', '', '', 2, '2', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(24, 1, 24, 'No', '', '', 3, 'nein', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0),
	(24, 2, 24, 'Nein', '', '', 3, 'nein', '0.0000', '0.0000', '', 'not-managed', '0.0000', 0);